//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//  
using System;
using System.IO;
using System.Net;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Runtime.Remoting;
using System.Runtime.Remoting.Services;

using InteropNS;

namespace WebServiceClient
{
	/// <summary>
	/// Podsumowanie dla WebServiceForm.
	/// </summary>
	public class WebServiceForm : System.Windows.Forms.Form
	{
		private WeatherRetrieverSoap weather = null;
		private Calculator calculator = null;
		private Temperature temperatureService = null;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.TextBox temperature;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.TextBox barometer;
		private System.Windows.Forms.TextBox barometerDirection;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.PictureBox conditionsIcon;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.TextBox humidity;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.TextBox updated;
		private System.Windows.Forms.TextBox zipcode;
		private System.Windows.Forms.TextBox conditions;
		private System.Windows.Forms.TextBox expression;
		private System.Windows.Forms.Label label7;
		private System.Windows.Forms.TextBox result;
		private System.Windows.Forms.Label label9;
		private System.Windows.Forms.TextBox temperature2;
		/// <summary>
		/// Wymagana zmienna.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public WebServiceForm()
		{
			//
			// Wymagane do obsugi Windows Form Designer
			//
			InitializeComponent();

			weather = new WeatherRetrieverSoap();
			calculator = new Calculator();
			temperatureService = new Temperature();

		}

		/// <summary>
		/// Oczyszczenie uywanych zasobw.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Metoda wymagana do obsugi Designera - nie naley modyfikowa
		/// zawartoci tej metody przy uyciu edytora kodu.
		/// </summary>
		private void InitializeComponent()
		{
			this.label1 = new System.Windows.Forms.Label();
			this.zipcode = new System.Windows.Forms.TextBox();
			this.temperature = new System.Windows.Forms.TextBox();
			this.label2 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.barometer = new System.Windows.Forms.TextBox();
			this.barometerDirection = new System.Windows.Forms.TextBox();
			this.label4 = new System.Windows.Forms.Label();
			this.conditions = new System.Windows.Forms.TextBox();
			this.conditionsIcon = new System.Windows.Forms.PictureBox();
			this.label5 = new System.Windows.Forms.Label();
			this.humidity = new System.Windows.Forms.TextBox();
			this.label6 = new System.Windows.Forms.Label();
			this.updated = new System.Windows.Forms.TextBox();
			this.expression = new System.Windows.Forms.TextBox();
			this.label7 = new System.Windows.Forms.Label();
			this.result = new System.Windows.Forms.TextBox();
			this.label9 = new System.Windows.Forms.Label();
			this.temperature2 = new System.Windows.Forms.TextBox();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.Font = new System.Drawing.Font("Arial Unicode MS", 12F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label1.Location = new System.Drawing.Point(8, 16);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(80, 23);
			this.label1.TabIndex = 0;
			this.label1.Text = "Kod pocztowy";
			// 
			// zipcode
			// 
			this.zipcode.Font = new System.Drawing.Font("Arial Unicode MS", 12F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.zipcode.Location = new System.Drawing.Point(184, 8);
			this.zipcode.Name = "zipcode";
			this.zipcode.TabIndex = 1;
			this.zipcode.Text = "";
			this.zipcode.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.zipcode.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.OnZipCodeKeyPress);
			this.zipcode.Leave += new System.EventHandler(this.OnZipCodeLeave);
			// 
			// temperature
			// 
			this.temperature.Location = new System.Drawing.Point(152, 104);
			this.temperature.Name = "temperature";
			this.temperature.ReadOnly = true;
			this.temperature.Size = new System.Drawing.Size(64, 20);
			this.temperature.TabIndex = 2;
			this.temperature.Text = "";
			this.temperature.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(80, 112);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(72, 16);
			this.label2.TabIndex = 3;
			this.label2.Text = "Temperatura";
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(224, 112);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(72, 16);
			this.label3.TabIndex = 4;
			this.label3.Text = "Barometr";
			// 
			// barometer
			// 
			this.barometer.Location = new System.Drawing.Point(296, 104);
			this.barometer.Name = "barometer";
			this.barometer.ReadOnly = true;
			this.barometer.Size = new System.Drawing.Size(64, 20);
			this.barometer.TabIndex = 5;
			this.barometer.Text = "";
			this.barometer.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// barometerDirection
			// 
			this.barometerDirection.Location = new System.Drawing.Point(296, 128);
			this.barometerDirection.Name = "barometerDirection";
			this.barometerDirection.ReadOnly = true;
			this.barometerDirection.Size = new System.Drawing.Size(64, 20);
			this.barometerDirection.TabIndex = 6;
			this.barometerDirection.Text = "";
			this.barometerDirection.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(80, 56);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(72, 16);
			this.label4.TabIndex = 7;
			this.label4.Text = "Warunki";
			// 
			// conditions
			// 
			this.conditions.Location = new System.Drawing.Point(184, 48);
			this.conditions.Name = "conditions";
			this.conditions.ReadOnly = true;
			this.conditions.Size = new System.Drawing.Size(176, 20);
			this.conditions.TabIndex = 8;
			this.conditions.Text = "";
			this.conditions.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// conditionsIcon
			// 
			this.conditionsIcon.Location = new System.Drawing.Point(8, 48);
			this.conditionsIcon.Name = "conditionsIcon";
			this.conditionsIcon.Size = new System.Drawing.Size(72, 80);
			this.conditionsIcon.TabIndex = 9;
			this.conditionsIcon.TabStop = false;
			// 
			// label5
			// 
			this.label5.Location = new System.Drawing.Point(80, 136);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(72, 16);
			this.label5.TabIndex = 10;
			this.label5.Text = "Wilgotno";
			// 
			// humidity
			// 
			this.humidity.Location = new System.Drawing.Point(152, 128);
			this.humidity.Name = "humidity";
			this.humidity.ReadOnly = true;
			this.humidity.Size = new System.Drawing.Size(64, 20);
			this.humidity.TabIndex = 11;
			this.humidity.Text = "";
			this.humidity.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// label6
			// 
			this.label6.Location = new System.Drawing.Point(80, 80);
			this.label6.Name = "label6";
			this.label6.Size = new System.Drawing.Size(72, 16);
			this.label6.TabIndex = 12;
			this.label6.Text = "Aktualizacja";
			// 
			// updated
			// 
			this.updated.Location = new System.Drawing.Point(184, 72);
			this.updated.Name = "updated";
			this.updated.ReadOnly = true;
			this.updated.Size = new System.Drawing.Size(176, 20);
			this.updated.TabIndex = 13;
			this.updated.Text = "";
			this.updated.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// expression
			// 
			this.expression.Font = new System.Drawing.Font("Arial Unicode MS", 12F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.expression.Location = new System.Drawing.Point(184, 216);
			this.expression.Name = "expression";
			this.expression.Size = new System.Drawing.Size(176, 29);
			this.expression.TabIndex = 15;
			this.expression.Text = "";
			this.expression.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.expression.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.OnExpressionKeyPress);
			this.expression.Leave += new System.EventHandler(this.OnExpressionLeave);
			// 
			// label7
			// 
			this.label7.Font = new System.Drawing.Font("Arial Unicode MS", 12F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label7.Location = new System.Drawing.Point(8, 224);
			this.label7.Name = "label7";
			this.label7.Size = new System.Drawing.Size(168, 23);
			this.label7.TabIndex = 14;
			this.label7.Text = "Wyraenie algebraiczne";
			// 
			// result
			// 
			this.result.Font = new System.Drawing.Font("Arial Unicode MS", 12F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.result.Location = new System.Drawing.Point(184, 256);
			this.result.Name = "result";
			this.result.ReadOnly = true;
			this.result.Size = new System.Drawing.Size(176, 29);
			this.result.TabIndex = 16;
			this.result.Text = "";
			this.result.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// label9
			// 
			this.label9.Location = new System.Drawing.Point(80, 176);
			this.label9.Name = "label9";
			this.label9.Size = new System.Drawing.Size(72, 16);
			this.label9.TabIndex = 18;
			this.label9.Text = "Temperatura";
			// 
			// temperature2
			// 
			this.temperature2.Location = new System.Drawing.Point(152, 176);
			this.temperature2.Name = "temperature2";
			this.temperature2.ReadOnly = true;
			this.temperature2.Size = new System.Drawing.Size(64, 20);
			this.temperature2.TabIndex = 17;
			this.temperature2.Text = "";
			this.temperature2.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// WebServiceForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(376, 294);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.label9,
																		  this.temperature2,
																		  this.result,
																		  this.expression,
																		  this.label7,
																		  this.updated,
																		  this.label6,
																		  this.humidity,
																		  this.label5,
																		  this.conditionsIcon,
																		  this.conditions,
																		  this.label4,
																		  this.barometerDirection,
																		  this.barometer,
																		  this.label3,
																		  this.label2,
																		  this.temperature,
																		  this.zipcode,
																		  this.label1});
			this.Name = "WebServiceForm";
			this.Text = "Usugi internetowe";
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Gwny punkt wejcia dla aplikacji.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new WebServiceForm());
		}

		private void FillInWeather(string zip)
		{
			InteropNS1.CurrentWeather cw = weather.GetWeather(zip);
			temperature.Text = Convert.ToString(cw.CurrentTemp);
			barometer.Text = Convert.ToString(cw.Barometer);
			barometerDirection.Text = cw.BarometerDirection;
			conditions.Text = cw.Conditions;
			humidity.Text = Convert.ToString(cw.Humidity);
			updated.Text = cw.LastUpdated;

			WebClient wc = new WebClient();
			Stream imageStream = wc.OpenRead (cw.IconUrl);

			Bitmap bi = new Bitmap(imageStream);
			conditionsIcon.Image = bi;
			imageStream.Close();

			temperature2.Text = Convert.ToString(temperatureService.getTemp(zip));
		}

		private void OnZipCodeKeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			TextBox tb = sender as TextBox;
			if(tb == null)
				return;
			if(e.KeyChar == '\r' && tb.Text!= "" )
			{
				FillInWeather(tb.Text);
			}
		}

		private void OnZipCodeLeave(object sender, System.EventArgs e)
		{
			TextBox tb = sender as TextBox;
			if(tb == null)
				return;
			FillInWeather(tb.Text);
		}

		private void EvaluateExpression(string expression)
		{
			result.Text = calculator.Evaluate(expression);
		}

		private void OnExpressionKeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			TextBox tb = sender as TextBox;
			if(tb == null)
				return;
			if(e.KeyChar == '\r' && tb.Text!= "" )
			{
				EvaluateExpression(tb.Text);
			}		
		}
		private void OnExpressionLeave(object sender, System.EventArgs e)
		{
			TextBox tb = sender as TextBox;
			if(tb == null)
				return;
			EvaluateExpression(tb.Text);		
		}

	}
}
